/* ============ */
/* kscalc.c	*/
/* ============ */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <mconf.h>
#include <miscdefs.h>

static  int  DblCmprFun(const void *Key, const void *Elem)
{
    return (*(double *) Key > *(double *) Elem) ?  1 :
	   (*(double *) Key < *(double *) Elem) ? -1 : 0;
}
/* ==================================================================== */
/* KSCalc - Calculates Kolmogorov-Smirnov Statistics and Probabilities	*/
/* ==================================================================== */
void
KSCalc(double KSArray[], int ArraySize, double *KPStat, double *KPProb,
	double *KMStat, double *KMProb)
{
    int	    k;
    double  MaxKnMinus, MaxKnPlus;

    /* -------------------------------------------------------- */
    /* Expressions for the Kolmogorov-Smirnov Statistics and	*/
    /* Probabilities Can Be Found in Knuth, Donald E., The Art	*/
    /* of Computer Programming, Vol 2, Second Edition, 1981	*/
    /* -------------------------------------------------------- */

    /* -------------------------------------------------------- */
    /* Calculate K-S on Chi-Square Statistics and Probabilities */
    /* -------------------------------------------------------- */

    /* ----------------------------- */
    /* Sort Array in Ascending Order */
    /* ----------------------------- */
    qsort(KSArray, ArraySize, sizeof(double), DblCmprFun);

    MaxKnMinus = MaxKnPlus = -100000.0;
    for (k = 1; k <= ArraySize; ++k)
    {
	double  NextKn;

	/* ---------------------- */
	/* Find Final Kn+ and Kn- */
	/* ---------------------- */
	NextKn = (double)k/(double)ArraySize - KSArray[k-1];
	MaxKnPlus = __max(MaxKnPlus, NextKn);

	NextKn = 1.0/(double)ArraySize - NextKn;
	MaxKnMinus = __max(MaxKnMinus, NextKn);
    }

    /* -------------------------------------------------- */
    /* Store Statistics and Probabilities for Kn+ and Kn- */
    /* -------------------------------------------------- */
    *KPStat = MaxKnPlus > 0 ? MaxKnPlus : 0;
    *KPProb = KSmirnov(ArraySize, *KPStat);

    *KMStat = MaxKnMinus > 0 ? MaxKnMinus : 0;;
    *KMProb = KSmirnov(ArraySize, *KMStat);
}
